/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.config.schedule.elements;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchsupport.jobs.config.schedule.elements.HumanReadableCronTrigger;
import com.floragunn.searchsupport.jobs.config.schedule.elements.TriggerFactory;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.TimeOfDay;
import org.quartz.impl.triggers.CronTriggerImpl;

public class MonthlyTrigger
extends HumanReadableCronTrigger<MonthlyTrigger> {
    private static final long serialVersionUID = -6518785696829462600L;
    private List<Integer> on;
    private List<TimeOfDay> at;
    public static final TriggerFactory<MonthlyTrigger> FACTORY = new TriggerFactory<MonthlyTrigger>(){

        @Override
        public String getType() {
            return "monthly";
        }

        @Override
        public MonthlyTrigger create(DocNode jsonNode, TimeZone timeZone) throws ConfigValidationException {
            return MonthlyTrigger.create(jsonNode, timeZone);
        }
    };

    public MonthlyTrigger(List<Integer> on, List<TimeOfDay> at, TimeZone timeZone) {
        this.on = Collections.unmodifiableList(on);
        this.at = Collections.unmodifiableList(at);
        this.timeZone = timeZone;
        this.init();
    }

    public ScheduleBuilder<MonthlyTrigger> getScheduleBuilder() {
        return null;
    }

    @Override
    protected List<CronTriggerImpl> buildCronTriggers() {
        ArrayList<CronTriggerImpl> result = new ArrayList<CronTriggerImpl>();
        for (TimeOfDay timeOfDay : this.at) {
            CronTriggerImpl cronTigger = (CronTriggerImpl)CronScheduleBuilder.cronSchedule((CronExpression)MonthlyTrigger.createCronExpression(timeOfDay, this.on)).build();
            result.add(cronTigger);
        }
        return result;
    }

    public List<Integer> getOn() {
        return this.on;
    }

    public void setOn(List<Integer> on) {
        this.on = on;
    }

    public List<TimeOfDay> getAt() {
        return this.at;
    }

    public void setAt(List<TimeOfDay> at) {
        this.at = at;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.on.size() == 1) {
            builder.field("on", this.on.get(0));
        } else {
            builder.array("on", new Object[]{this.on});
        }
        if (this.at.size() == 1) {
            builder.field("at", MonthlyTrigger.format(this.at.get(0)));
        } else {
            builder.startArray("at");
            for (TimeOfDay timeOfDay : this.at) {
                builder.value(MonthlyTrigger.format(timeOfDay));
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public static MonthlyTrigger create(DocNode jsonNode, TimeZone timeZone) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vDocNode = new ValidatingDocNode(jsonNode, validationErrors);
        Object on = ((ValidatingDocNode.Attribute)vDocNode.get("on").expected("Day of Month: 1-31")).asList().inRange(1, 31).ofIntegers();
        ImmutableList at = vDocNode.get("at").required().viaStringsAsList(s -> MonthlyTrigger.parseTimeOfDay(s));
        if (on == null) {
            on = Collections.emptyList();
        }
        return new MonthlyTrigger((List<Integer>)on, (List<TimeOfDay>)at, timeZone);
    }

    private static CronExpression createCronExpression(TimeOfDay timeOfDay, List<Integer> on) {
        try {
            StringBuilder result = new StringBuilder();
            result.append(timeOfDay.getSecond()).append(' ');
            result.append(timeOfDay.getMinute()).append(' ');
            result.append(timeOfDay.getHour()).append(' ');
            if (on.size() == 0) {
                result.append("*");
            } else {
                boolean first = true;
                for (Integer dayOfMonth : on) {
                    if (first) {
                        first = false;
                    } else {
                        result.append(",");
                    }
                    result.append(dayOfMonth);
                }
            }
            result.append(" * ?");
            return new CronExpression(result.toString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

